package intelligence;

import cz.cuni.pogamut.Client.Agent;
import java.util.LinkedList;
import java.util.logging.Level;

public class Intelligence {
    private Agent agent;
    private LinkedList<Thought> thoughts = new LinkedList();
    // helper variable allowing or disallowing debug logs
    public boolean fullLogging = false;
    
    public Intelligence(Agent agent) {
        this.agent = agent;
    }
    
    public void clear() {
        for (Thought t: thoughts) {
            t.interrupt();
        }
        thoughts.clear();
    }
    
    public Agent getAgent() {
        return agent;
    }
    
    public Thought getCurrentThought() {
        if (thoughts.isEmpty()) {
            return null;
        } else {
            return thoughts.getFirst();
        }
    }
    
    public synchronized void runThought(Class c) {
        if (thoughts.isEmpty() || thoughts.getFirst().getClass() != c) {
            try {
                pushThought(Thought.create(c, this));       
            } catch (IllegalAccessException e) {
                agent.getPlatformLog().log(Level.SEVERE,
                        "Illegal acces exception when creating thought: " + e.getMessage());
            } catch (InstantiationException e) {
                agent.getPlatformLog().log(Level.SEVERE,
                        "Instantiation exception when creating thought: " + e.getMessage());                
            }
        }  
    }
    
    private void pushThought(Thought t) {
        if (!thoughts.isEmpty()) {
            // suspend may cause deadlock - we shouldn't suspend thread
            // when it's in critical section
            synchronized (agent) {
                thoughts.getFirst().suspend();
            }
        }
        thoughts.push(t);
        if (fullLogging) {
            agent.log.info("Thought added");
        }
    }
        
    public synchronized void removeThought(Thought thought) {
        if (thoughts.getFirst() == thought) {
            thoughts.pop();
            if (fullLogging) {
                agent.log.info("Thought removed");
            }
            if (thoughts.size() != 0) {
                thoughts.getFirst().resume();
            }
        } else {
            thoughts.remove(thought);
        }
    }
}